unit FreqMeasure;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  OleCtrls, DlsrLib_TLB, StdCtrls, ExtCtrls, Buttons;

type
  TForm1 = class(TForm)
    DriverLINXSR1: TDriverLINXSR;
    cmdOpen: TButton;
    lblStatus: TLabel;
    cmdStart: TButton;
    Timer1: TTimer;
    Label1: TLabel;
    Label2: TLabel;
    cmdClose: TBitBtn;
    Label3: TLabel;
    cmdHelp: TButton;
    deviceNum: TEdit;
    Label4: TLabel;
    procedure cmdOpenClick(Sender: TObject);
    procedure cmdStartClick(Sender: TObject);
    procedure TimeElapsed(Sender: TObject);
    procedure UnloadDriverLINX(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure cmdHelpClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses frmHelp;

{$R *.DFM}

procedure TForm1.cmdOpenClick(Sender: TObject);
begin
{
  Tested with CTM-05/A in Win95B using initial release of DriverLINX
  for CTM boards (version 4.01) and version CTM-850A01.0.0.2 (initial
  release + the patch file applied.

  Application was written in Delphi 3.0 Standard Edition.  The DriverLINX
  ActiveX controls have been imported into Delphi's IDE.

  Naming conventions:  The AM9513A chip on the CTM board has 5 counters:
  counters 1 through 5.  This agrees with the User's Guide which gives
  wiring information (ACIN1 .. ACIN5).

  DriverLINX uses zero based numbering so these counters (1.. 5) correspond
  to logical channels 0 through 4.

  Connections required:

  - connect signal of interest to input of counter 1 (pin 36 of CTM-05/A).  This
    signal will actually be routed to the input of counter 2 when the code
    asks for SOURCE1.  This complex signal routing capability is a feature of the
    AM9513A chip used on the CTM boards.

  - use jumper wire to connect output of counter 1 (pin 35) to gate of
    counter 2 (pin 18).

  - if you are using a CTM-10, the pin numbers will be different.  Refer to the
    CTM-10 & CTM-05/A User's Guide.

   Freq Measurement will make use of two channels:  one to generate a gating
   pulse and one to do gated event counting.  The number of counts accumulated
   during the gating interval divided by the duration of the gate will be
   the freq of the applied signal.

 }

With DriverLINXSR1 do

    begin
       Req_DLL_name := 'kmbctm';
       Req_device := StrToInt(deviceNum.text);
       Req_op := DL_INITIALIZE;
       Req_mode := DL_OTHER;
       Req_subsystem := DL_DEVICE;
       Refresh;
    end;
    if (DriverLINXSR1.Res_result = DL_NoErr)
     then
     cmdStart.Enabled := True
    else
    lblStatus.Caption := DriverLINXSR1.Message;

    Form1.SetFocus;  // return focus to our form
end;

procedure TForm1.cmdStartClick(Sender: TObject);
begin
   With DriverLINXSR1 do

    begin
         Req_op := DL_START;
         Req_mode := DL_POLLED;
         Req_subsystem := DL_CT;
         Evt_Str_type := DL_COMMAND;    // start when refresh is called
         Evt_Stp_type := DL_NULLEVENT;  // no stop type required
         Evt_Tim_type := DL_RATEEVENT;
         Evt_Tim_rateClock := DL_SOURCE1;  // use the signal connected to logical chan 0 input
         Evt_Tim_rateChannel := 0;      // logical channel 0 of CT subsystem
         Evt_Tim_rateGate := DL_NOCONNECT;   // channel 0 will not be gated
         Evt_Tim_rateMode := DL_FREQ;  // perform a FREQ measurement
         Evt_Tim_rateOnCount := DLSecs2Tics(DL_INTERNAL1, 1.0);  // generate a 1 second gate pulse
         Evt_Tim_ratePeriod := 0;  // not used
         Evt_Tim_ratePulses := 1;  // is a one-shot measurement
         Evt_Tim_rateOutput := CT_Output_Default;  // default outputs from the counters
         Sel_chan_N := 0;     // no channels or buffers
         Sel_buf_N := 0;
         Refresh;
     End;
     timer1.Interval := 1010;  // a little longer than Evt_Tim_rateOnCount
     lblStatus.Caption := 'Measuring.....';
     label1.Caption := '';  // blank out any old reading displayed in the label

     if (DriverLINXSR1.Res_result = DL_NoErr)
     then
       timer1.Enabled := True  // start our timer object
     else
       lblStatus.Caption := DriverLINXSR1.Message;


end;

procedure TForm1.TimeElapsed(Sender: TObject);
begin
Beep;
// If DriverLINXSR1.Res_Tim_status = DL_done Then
 //begin
             With DriverLINXSR1 do
              begin
              Res_Sta_typeStatus := DL_TIMERSTATUS;
              Req_op := DL_STATUS;
              Refresh;
              Refresh;  // driverlinx has a bug, need to read it twice
              label1.caption := IntToStr(Res_Tim_count);
              // freq will be the pulses counted divided by the duration
              // of the gating pulse
              end;  // with
//              end;  // if
// disable the timer
Timer1.Enabled := False;
     if (DriverLINXSR1.Res_result = DL_NoErr)
     then
       lblStatus.Caption := 'Measurement is complete.'
     else
       lblStatus.Caption := DriverLINXSR1.Message;
end;


procedure TForm1.UnloadDriverLINX(Sender: TObject;
  var Action: TCloseAction);
begin
DriverLINXSR1.Req_DLL_name := ''; // set to NULL string to close the driver
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
form1.Caption := 'Frequency Measurement with CTM Boards';
end;

procedure TForm1.cmdHelpClick(Sender: TObject);
begin
if Form2.Visible = False then Form2.Visible := True;
Form2.BringToFront;

end;

end.
